package jp.ne.ytp.test.util.tree;

import jp.ne.ytp.util.tree.MultiKeyTree;
import jp.ne.ytp.util.tree.TreeActionListener;

public class MultiKeyTreeTester implements TreeActionListener {
    private static int LAYER = 3;
    private int num_ = 0;
    
    public static void main(String[] args) {
        MultiKeyTreeTester tester = new MultiKeyTreeTester();
        tester.test(args);
    }
    
    public void test(String[] args) {
        MultiKeyTree tree = new MultiKeyTree(LAYER);
        Object[][] keys = {
             {"xx", "bbb", 111}
            ,{"xx", "ccc", 222}
            ,{"xx", "bbb", 100}
            ,{"xx", "bbb", 19}
            ,{"aaa", "eee", 555}
            ,{"aaa", "bbb", 666}
            ,{"aaa", "bbb", 77}
        };
        
        // アクションリスナーの登録
        tree.addListener(this);
        
        // キーの登録
        for (int i = 0; i < keys.length; i++) {
            num_ = i + 1;
            tree.put(keys[i]);
        }
        
        // 木の走査
        tree.traverse();
    }
    
    /*** 以下はTreeActionListenerインタフェースの実装 ***/
    
    /*** 木作成時の処理 ***/
    public Object initializeRoot() {
        return new Integer(0);
    }
    
    public Object create(int iLayer) {
        // レコード番号をノードデータとする
        return new Integer(num_);
    }
    
    public Object match(int iLayer, Object nodeData) {
        // レコード番号をノードデータに加算する
        return new Integer(num_ + ((Integer)nodeData).intValue());
    }
    
    /*** 走査時の処理 ***/
    public void sort(Object[] keys, int iLayer, Object nodeData) {
        indent(iLayer);
        
        // キーと値の表示
        System.out.print("D:" + iLayer);
        for (int i = 0; i < keys.length; i++) {
            System.out.print(" " + keys[i]);
        }
        System.out.println(" (" + nodeData + ")");
    }
    
    public void makeHeader(Object key, int iLayer, Object nodeData) {
        indent(iLayer);
        
        // キーと値の表示
        System.out.println("H:" + iLayer + " " + key + " (" + nodeData + ")");
    }
    
    public void makeFooter(Object key, int iLayer, Object nodeData) {
        indent(iLayer);
        
        // キーと値の表示
        System.out.println("F:" + iLayer + " " + key + " (" + nodeData + ")");
    }
    
    private void indent(int iLayer) {
        // インデントの設定
        for (int i = 0; i < iLayer * 2; i++) {
            System.out.print(" ");
        }
    }
}