/*
 *  Copyright(c) 2016. Your Technology Partner(YTP). All rights reserved.
 *  
 *  このプログラムの著作権はYour Technology Partner(YTP)が保有します。
 *  このプログラムはアパッチソフトウェアライセンスに従って配布します。
 *  このプログラムを再配布あるいは改造する場合は、上記著作権表示を必ず
 *  含めるようにして下さい。免責事項も同ライセンスに準じます。詳細は
 *  http://www.apache.org/LICENSE を参照して下さい。
 *  
 *  Your Technology Partner(YTP) owns the copyright of this program.
 *  This program is provided in conformity with The Apache Software
 *  License agreement. Redistribution and reproduction must contain
 *  the above copyright notice. The Disclaimer is also based on
 *  The Apache Software License. Redistributor can refer to
 *  http://www.apache.org/LICENSE for further details.
 */

package jp.ne.ytp.util;

import java.util.Comparator;

/**
 *  キーの比較に使用する標準のコンパレータです。
 *  比較対象の2つのオブジェクトが{@link Comparable}Comparableインタフェースを実装している場合は{@link Comparable#compareTo(Object)}メソッドによる比較結果を、
 *  実装していない場合はそのオブジェクトの文字列表現(toString())を使用して辞書順比較を行います。<br>
 *  コンパレータを取得する際には{@link DefaultComparator#getComparator()}
 *  メソッドを呼び出して下さい。
 *  当クラスはシングルトンデザインパターンで実装されています。
 *  @see java.util.Comparator
 *  @author YTP
 */
public class DefaultComparator implements Comparator<Object> {
    /**
     *  唯一のDefaultComparatorインスタンスです。
     */
    private static DefaultComparator comp_ = new DefaultComparator();
    
    /**
     *  デフォルトコンストラクタは使用できません。
     */
    private DefaultComparator() {
    }
    /**
     *  標準のコンパレータを返します。
     */
    public static Comparator<Object> getComparator() {
        return comp_;
    }
    
    /**
     *  指定された2つのオブジェクトが{@link Comparable}Comparableインタフェースを実装している場合は{@link Comparable#compareTo(Object)}メソッドによる比較結果を、
     *  実装していない場合はそのオブジェクトの文字列表現(toString())の比較結果を(つまり辞書順比較)返します。
     *  文字列表現による比較はそれぞれの文字のUnicode値に基づいて行われます。<br>
     *  @param o1 比較元のオブジェクト
     *  @param o2 比較相手のオブジェクト
     *  @return 比較した結果
     *  <ul>
     *      <li>o1がo2より小さい場合は負の値</li>
     *      <li>o1がo2より大きい場合は正の値</li>
     *      <li>o1がo2と等しい場合は0</li>
     *  </ul>
     */
    @SuppressWarnings("unchecked")
	public int compare(Object o1, Object o2) {
    	if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable<Object>)o1).compareTo(o2);
    	} else {
            return o1.toString().compareTo(o2.toString());
    	}
    }
}
