/*
 *  Copyright(c) 2016. Your Technology Partner(YTP). All rights reserved.
 *  
 *  このプログラムの著作権はYour Technology Partner(YTP)が保有します。
 *  このプログラムはアパッチソフトウェアライセンスに従って配布します。
 *  このプログラムを再配布あるいは改造する場合は、上記著作権表示を必ず
 *  含めるようにして下さい。免責事項も同ライセンスに準じます。詳細は
 *  http://www.apache.org/LICENSE を参照して下さい。
 *  
 *  Your Technology Partner(YTP) owns the copyright of this program.
 *  This program is provided in conformity with The Apache Software
 *  License agreement. Redistribution and reproduction must contain
 *  the above copyright notice. The Disclaimer is also based on
 *  The Apache Software License. Redistributor can refer to
 *  http://www.apache.org/LICENSE for further details.
 */

package jp.ne.ytp.util.tree;

import java.util.*;

/**
 *  {@link MultiKeyTree}クラスが1階層分の走査を行なう際に、
 *  内部的に使用する{@link OneLayerListener}の実装クラスです。
 *  @see MultiKeyTree OneLayerListener
 *  @author YTP
 */
class InternalOneLayer implements OneLayerListener {
    /**
     *  キーの集合です。
     */
    private List<Object> keys_ = null;
    
    /**
     *  値の集合です。
     */
    private List<Object> values_ = null;
    
    /**
     *  キーと値を保存します。
     *  このメソッドは{@link OneLayerListener}インタフェースの実装です。
     *  このメソッドを実装する側で出力処理等を記述して下さい。
     *  @param key ノードのキー
     *  @param value ノードのデータ
     */
    public void sortOneLayer(Object key, Object value) {
        keys_.add(key);
        values_.add(value);
    }
    
    /**
     *  キーと値の保存領域を初期化します。
     */
    void init() {
        keys_ = new ArrayList<Object>();
        values_ = new ArrayList<Object>();
    }
    
    /**
     *  保存したキーの集合を返します。
     *  @return キーの集合
     */
    List<Object> getKeys() {
        return keys_;
    }
    
    /**
     *  保存した値の集合を返します。
     *  @return 値の集合
     */
    List<Object> getValues() {
        return values_;
    }
}
