/*
 *  Copyright(c) 2016. Your Technology Partner(YTP). All rights reserved.
 *  
 *  このプログラムの著作権はYour Technology Partner(YTP)が保有します。
 *  このプログラムはアパッチソフトウェアライセンスに従って配布します。
 *  このプログラムを再配布あるいは改造する場合は、上記著作権表示を必ず
 *  含めるようにして下さい。免責事項も同ライセンスに準じます。詳細は
 *  http://www.apache.org/LICENSE を参照して下さい。
 *  
 *  Your Technology Partner(YTP) owns the copyright of this program.
 *  This program is provided in conformity with The Apache Software
 *  License agreement. Redistribution and reproduction must contain
 *  the above copyright notice. The Disclaimer is also based on
 *  The Apache Software License. Redistributor can refer to
 *  http://www.apache.org/LICENSE for further details.
 */

package jp.ne.ytp.util.tree;

/**
 *  {@link MultiKeyTree}クラスの1階層分の走査を行なう際に、
 *  イベント通知するためのメソッドを規定するインタフェースです。
 *  @see MultiKeyTree
 *  @see TreeActionListener
 *  @author YTP
 */
public interface OneLayerListener extends java.util.EventListener {
    /**
     *  1階層分の走査を実行する際に、各ノードごとに呼び出すメソッドです。
     *  このメソッドを実装する側で出力処理等を記述して下さい。
     *  @param key ノードのキー
     *  @param value ノードのデータ
     */
    public void sortOneLayer(Object key, Object value);
}
